package com.tapresearch.test.internal

import android.content.Context

internal object TRTestInternal {

    /**
     * Enable test - internal for public sample apps only!
     *
     * @param context
     * @param enable
     */
    internal fun enableTestEnvironment(context: Context, enable: Boolean) {
        try {

            // only works for TapResearch internal apps and public sample apps
            // that contain 'tapresearch' in the package name
            if (!context.packageName.contains("tapresearch",true)) {
                return
            }

            if (enable) {
                context.getSharedPreferences(
                    "tap-rewards-load-hoth-environment",
                    0
                ).edit().putBoolean("tap-rewards-load-hoth-environment", true).commit()
                context.getSharedPreferences("tr_orca_params", 0).edit().putString(
                    "device_id",
                    ""
                ).commit()

            } else {
                context.getSharedPreferences(
                    "tap-rewards-load-hoth-environment",
                    0
                ).edit().putBoolean("tap-rewards-load-hoth-environment", false).commit()
                if (context.getSharedPreferences("tr_orca_params", 0).getString("device_id", "-1").equals("")) {
                    context.getSharedPreferences("tr_orca_params", 0).edit().remove("device_id").commit()
                }
            }
        }catch (_: Throwable){}
    }

}
