package com.tapresearch.tapsdk.callback

/**
 * TapResearch SDK ready callback.  Indicates when the TapResearch SDK is ready for use and ready
 * to display content, such as the Survey Wall, Interstitials, Quick Questions, etc.
 *
 * @see com.tapresearch.tapsdk.TapResearch.initialize
 *
 */
fun interface TRSdkReadyCallback {

    /**
     * Invoked some short moments after TapResearch.initialize has been called indicating that
     * the TapResearch SDK is ready for use.  I.e. TapResearch.showContentForPlacement can now
     * be called and the Survey Wall activity can be shown.
     *
     * @see com.tapresearch.tapsdk.TapResearch.initialize
     */
    fun onTapResearchSdkReady()
}
