package com.tapresearch.tapsdk.callback

import com.tapresearch.tapsdk.models.TRReward

/**
 * TapResearch reward callback.  Indicates a reward event has occurred.  E.g. after user successfully
 * completes a survey and has closed the Survey Wall.  Please note there are other things that can
 * trigger reward events besides completing surveys.  Survey completes are the most common!
 *
 * @see com.tapresearch.tapsdk.TapResearch.setRewardCallback
 * @see com.tapresearch.tapsdk.TapResearch.initialize
 *
 */
fun interface TRRewardCallback {

    /**
     * Invoked whenever a survey or user profile questionnaire is completed and the Survey Wall screen is dismissed.
     * Can also be invoked arbitrarily by TapResearch based on previously un-redeemed rewards or other reasons.
     *
     * @param rewards - Could be one or more TapResearch reward objects.
     * @see com.tapresearch.tapsdk.models.TRReward
     */
    fun onTapResearchDidReceiveRewards(rewards: MutableList<TRReward>)
}
