package com.tapresearch.tapsdk.models

import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@OptIn(InternalSerializationApi::class) @Serializable
data class TRBonusTier(
    @SerialName("tier_number")
    val tierNumber: Int? = null,
    @SerialName("completes_needed")
    val completesNeeded: Int? = null,
    @SerialName("reward_amount")
    val rewardAmount: Float? = null,
    @SerialName("status")
    var status: String? = null,
)

@OptIn(InternalSerializationApi::class) @Serializable
data class TRBonusBarProgress(
    @SerialName("is_active")
    val isActive: Boolean? = null,
    @SerialName("current_completes")
    val currentCompletes: Int? = null,
    @SerialName("bonus_window_end_at")
    var bonusWindowEndAt: String? = null,  //UTC date string
    @SerialName("bonus_tiers")
    val bonusTiers: List<TRBonusTier>? = null,
    @SerialName("error")
    val error: TRError? = null,
)

