package com.tapresearch.tapsdk.callback

/**
 * TapResearch content callback
 *
 */
interface TRContentCallback {
    /**
     * Invoked whenever the TapResearch Survey Wall activity is shown or Quick Question appears
     * on screen.
     *
     * @param placementTag - The placement tag string.  E.g. "home-screen" or "earn-center"
     */
    fun onTapResearchContentShown(placementTag: String)

    /**
     * Invoked whenever the TapResearch Survey Wall activity is dismissed or Quick Question
     * dialog is dismissed.
     *
     * @param placementTag - The placement tag string.  E.g. "home-screen" or "earn-center"
     */
    fun onTapResearchContentDismissed(placementTag: String)
}
