package com.tapresearch.tapsdk.utils

enum class TapErrorCodes(val code: Int, val description: String) {

    /**
     * Invalid API token (Error Code: 1000)
     */
    INVALID_API_TOKEN(1000, "Invalid API token"),

    /**
     * Missing User Identifier (Error Code: 1001)
     */
    MISSING_USER_IDENTIFIER(1001, "Missing user identifier"),

    /**
     * Service Unavailable (Error Code: 1002)
     */
    SERVICE_UNAVAILABLE(1002, "Service unavailable"),

    /**
     * Missing header (Error Code: 1003)
     */
    MISSING_HEADER(1003, "Missing header"),

    /**
     * Network timeout (Error Code: 1004)
     */
    NETWORK_TIMEOUT(1004, "Network timeout"),

    /**
     * Unknown network error (Error Code: 1005)
     */
    NETWORK_ERROR(1005, "Unknown network error"),

    /**
     * Javascript execution error (Error Code: 1006)
     */
    JAVASCRIPT_EXECUTION_ERROR(1006, "Javascript execution error"),

    /**
     * App unavailable (Error Code: 1007)
     */
    APP_UNAVAILABLE(1007, "App unavailable"),

    /**
     * No internet connection (Error Code: 1008)
     */
    NO_INTERNET_CONNECTION(1008, "No internet connection"),

    /**
     * Missing required tag (Error Code:2000)
     */
    INVALID_TAG(2000, "Missing required tag"),

    /**
     * There is no content available for this placement (Error Code: 2001).  Most likely, the
     * api token is invalid.  Or the token is intended for iOS, not Android (or vice-versa).
     * Please check with your Tap Research account manager.
     */
    NO_CONTENT(2001, "There is no content available for this placement"),

    /**
     * Missing attribute (Error Code: 3000)
     */
    MISSING_ATTRIBUTE(3000, "Missing attribute"),

    /**
     * No configuration for landscape orientation while attempting to show in landscape (Error Code: 3001)
     */
    MISSING_LANDSCAPE_ORIENTATION(3001, "No configuration for landscape orientation while attempting to show in landscape"),

    /**
     * No configuration for portrait orientation while attempting to show in portrait (Error Code: 3002)
     */
    MISSING_PORTRAIT_ORIENTATION(3002, "No configuration for portrait orientation while attempting to show in portrait"),

    /**
     * Invalid reward identifiers (Error Code: 4000)
     */
    INVALID_REWARD_IDENTIFIER(4000, "Invalid reward identifier"),

    /**
     * Not initialized (Error Code: 6000)
     */
    NOT_INITIALIZED(6000, "Not initialized"),

    /**
     * Missing API token (Error Code: 6001)
     */
    MISSING_API_TOKEN(6001, "Missing API token"),

    /**
     * Unable to present UI (Error Code: 6002)
     */
    UNABLE_TO_PRESENT_UI(6002, "Unable to present UI"),

    /**
     * Unable to create UI (Error Code: 6003)
     */
    UNABLE_TO_CREATE_UI(6003, "Unable to create UI"),

    /**
     * Unable to decode TRError JSON (Error Code: 6004)
     */
    UNABLE_TO_DECODE(6004, "Unable to decode TRError JSON"),

    /**
     * Reward delegate was de-allocated or not set (Error Code: 6005)
     */
    REWARD_DELEGATE_ERROR(6005, "Reward delegate was de-allocated or not set"),

    /**
     * Bad or missing custom parameters (Error Code: 6006)
     */
    BAD_CUSTOM_PARAMS(6006, "Bad or missing custom parameters"),

    /**
     * Missing application context (Error Code: 6007)
     */
    MISSING_APPLICATION_CONTEXT(6007, "Missing application context"),

    /**
     * Missing placement tag (Error Code: 6008)
     */
    MISSING_PLACEMENT_TAG(6008, "Missing placement tag"),

    /**
     * Missing content callback (Error Code: 6009)
     */
    MISSING_CONTENT_CALLBACK(6009, "Missing content callback"),

    /**
     * SDK not ready (Error Code: 6010)
     */
    SDK_NOT_READY(6010, "SDK not ready"),

    /**
     * Unable to convert user attributes (Error Code: 6011)
     */
    UNABLE_TO_CONVERT_USER_ATTRIBUTES(6011, "Unable to convert user attributes"),

    /**
     * Invalid survey Id for placement (Error Code: 6012)
     */
    INVALID_SURVEY_ID_FOR_PLACEMENT(6012, "Invalid survey Id for placement"),

    /**
     * No surveys for placement (Error Code: 6013)
     */
    NO_SURVEYS_FOR_PLACEMENT(6013, "No surveys for placement"),

    /**
     * Quick Questions data delegate was deallocated or not set (Error Code: 6014)
     */
    QUICK_QUESTION_DELEGATE_ERROR(6014, "Quick Questions data delegate was deallocated or not set"),

    /**
     * Invalid boost tag (Error Code: 6015)
     */
    INVALID_BOOST_TAG(6015, "Invalid boost tag"),

    /**
     * Too many requests (Error Code: 6016)
     */
    TOO_MANY_REQUESTS(6016, "Too many requests"),

    /**
     * Placement details missing (Error Code: 6017)
     */
    PLACEMENT_DETAILS_MISSING(6017, "Placement details missing"),

    /**
     * Invalid notification command (Error Code: 10000)
     */
    INVALID_NOTIFICATION_COMMAND(10000, "Invalid notification command"),

    /**
     * Notification missing placementTag while command is showContent (Error Code: 10001)
     */
    NOTIFICATION_MISSING_PLACEMENT_TAG(10001, "Notification missing placementTag while command is showContent"),

    /**
     * Notification missing scheduledDate and timeDelta, cannot schedule. (Error Code: 10002)
     */
    MISSING_NOTIFICATION_TIME(10002, "Notification missing scheduledDate and timeDelta, cannot schedule"),;

    fun errorMessage(): String {
        return "[Error code $code] $description"
    }
}
