package com.tapresearch.tapsdk.callback

/**
 * Invoked whenever surveys of a certain placement have been refreshed and are ready to be
 * fetch again via TapResearch.getSurveysForPlacement.
 *
 * @see com.tapresearch.tapsdk.TapResearch.setSurveysRefreshedListener
 *
 */
fun interface TRSurveysRefreshedListener {

    /**
     * Invoked whenever surveys have been refreshed for a particular placement.  At this point,
     * TapResearch.getSurveysForPlacement should be called to get the updated list of surveys
     * for the placement.
     *
     * @param placementTag The placement tag string.  E.g. "home-screen" or "earn-center"
     * @see com.tapresearch.tapsdk.TapResearch.getSurveysForPlacement
     */
    fun onSurveysRefreshedForPlacement(placementTag: String)
}
