package com.tapresearch.tapsdk.utils

enum class TapErrorCodes(val code: Int, val description: String) {

    /**
     * Invalid API token (Error Code: 1000)
     */
    INVALID_API_TOKEN(1000, "Invalid API token"),

    /**
     * Missing User Identifier (Error Code: 1001)
     */
    MISSING_USER_IDENTIFIER(1001, "Missing user identifier"),

    /**
     * Service Unavailable (Error Code: 1002)
     */
    SERVICE_UNAVAILABLE(1002, "Service unavailable"),

    /**
     * Missing header (Error Code: 1003)
     */
    MISSING_HEADER(1003, "Missing header"),

    /**
     * Network timeout (Error Code: 1004)
     */
    NETWORK_TIMEOUT(1004, "Network timeout"),

    /**
     * Unknown network error (Error Code: 1005)
     */
    NETWORK_ERROR(1005, "Unknown network error"),

    /**
     * Missing required tag (Error Code:2000)
     */
    INVALID_TAG(2000, "Missing required tag"),

    /**
     * There is no content available for this placement (Error Code: 2001).  Most likely, the
     * api token is invalid.  Or the token is intended for iOS, not Android (or vice-versa).
     * Please check with Tap Research account manager.
     */
    NO_CONTENT(2001, "There is no content available for this placement"),

    /**
     * Missing attribute (Error Code: 3000)
     */
    MISSING_ATTRIBUTE(3000, "Missing attribute"),

    /**
     * Invalid reward identifiers (Error Code: 4000)
     */
    INVALID_REWARD_IDENTIFIERS(4000, "Invalid reward identifiers"),

    /**
     * Not initialized (Error Code: 6000)
     */
    NOT_INITIALIZED(6000, "Not initialized"),

    /**
     * Missing API token (Error Code: 6001)
     */
    MISSING_API_TOKEN(6001, "Missing API token"),

    /**
     * Unable to present UI (Error Code: 6002)
     */
    UNABLE_TO_PRESENT_UI(6002, "Unable to present UI"),

    /**
     * Unable to create UI (Error Code: 6003)
     */
    UNABLE_TO_CREATE_UI(6003, "Unable to create UI"),

    /**
     * Unable to decode TRError JSON (Error Code: 6004)
     */
    UNABLE_TO_DECODE(6004, "Unable to decode TRError JSON"),

    /**
     * Reward delegate was de-allocated or not set (Error Code: 6006)
     */
    REWARD_DELEGATE_ERROR(6006, "Reward delegate was de-allocated or not set"),

    /**
     * Bad or missing custom parameters (Error Code: 6006)
     */
    BAD_CUSTOM_PARAMS(6006, "Bad or missing custom parameters"),

    /**
     * Missing application context (Error Code: 6007)
     */
    MISSING_APPLICATION_CONTEXT(6007, "Missing application context"),

    /**
     * Missing placement tag (Error Code: 6008)
     */
    MISSING_PLACEMENT_TAG(6008, "Missing placement tag"),

    /**
     * Missing content callback (Error Code: 6009)
     */
    MISSING_CONTENT_CALLBACK(6009, "Missing content callback"),

    /**
     * SDK not ready (Error Code: 6010)
     */
    SDK_NOT_READY(6010, "SDK not ready"),

    /**
     * Initialization timeout. SDK not ready (Error Code: 6011)
     */
    INITIALIZATION_TIMEOUT(6011, "Initialization timeout. SDK not ready"),

    /**
     * Invalid Survey Id for placement (Error Code: 6012)
     */
    INVALID_SURVEY_ID_FOR_PLACEMENT(6012, "Invalid Survey Id for placement"),

    /**
     * No surveys for placement (Error Code: 6013)
     */
    NO_SURVEYS_FOR_PLACEMENT(6013, "No surveys for placement"),;

    fun errorMessage(): String {
        return "[Error code $code] $description"
    }
}
