package com.tapresearch.tapsdk.callback

import com.tapresearch.tapsdk.models.TRGrantBoostResponse
import kotlinx.serialization.InternalSerializationApi

/**
 * This callback happens after TapResearch.grantBoost has been called.
 *
 * @see com.tapresearch.tapsdk.TapResearch.grantBoost
 *
 */
fun interface TRGrantBoostResponseListener {

    /**
     * Occurs as a response to TapResearch.grantBoost.
     *
     * @param grantBoostResponse - The grant boost response.
     * @see com.tapresearch.tapsdk.TapResearch.grantBoost
     */
    @OptIn(InternalSerializationApi::class)
    fun onGrantBoostResponse(grantBoostResponse: TRGrantBoostResponse)
}
