package com.tapresearch.tapsdk.utils

import android.content.Context
import android.content.pm.PackageManager
import android.content.res.Configuration
import android.content.res.Resources
import android.os.Build
import com.tapresearch.tapresearchkotlinsdk.R
import com.tapresearch.tapsdk.utils.DeviceUtils.isFoldableDevice

internal object DeviceUtils {

    internal fun isFoldableDevice(context: Context): Boolean {
        return if (Build.VERSION.SDK_INT >= 30) {
            try {
                context.packageManager.hasSystemFeature(PackageManager.FEATURE_SENSOR_HINGE_ANGLE)
            }catch (_: Throwable) {false}
        } else {false}
    }

    /**
     * Only invoke on a foldable device; meaningless on a typical phone or tablet.
     * @see isFoldableDevice(context: Context)
     *
     * If the shorter side is greater than 70% of the longer side, then consider the device in
     * the 'flat' configuration.
     *
     * @return if the foldable device is in the 'flat' configuration
     */
    internal fun isFlat(): Boolean {
        return if (Resources.getSystem().displayMetrics.widthPixels > Resources.getSystem().displayMetrics.heightPixels) {
            Resources.getSystem().displayMetrics.heightPixels > Resources.getSystem().displayMetrics.widthPixels * .7f
        } else {
            Resources.getSystem().displayMetrics.widthPixels > Resources.getSystem().displayMetrics.heightPixels * .7f
        }
    }

    internal fun getDisplayDimensions(context: Context): String {
        return if (isFoldableDevice(context) && isFlat()) {
            val width = Resources.getSystem().displayMetrics.heightPixels / Resources.getSystem().displayMetrics.density
            val height = (Resources.getSystem().displayMetrics.widthPixels/2) / Resources.getSystem().displayMetrics.density
            "${width}x$height"
        } else {
            val width = Resources.getSystem().displayMetrics.widthPixels / Resources.getSystem().displayMetrics.density
            val height = Resources.getSystem().displayMetrics.heightPixels / Resources.getSystem().displayMetrics.density
            "${width}x$height"
        }
    }

    internal fun isPortrait(): Boolean {
        return Resources.getSystem().displayMetrics.heightPixels >= Resources.getSystem().displayMetrics.widthPixels
    }

    internal fun isLargeScreenDevice(context: Context): Boolean {
        return try {
            context.resources.getBoolean(R.bool.isLargeScreenDevice)
        }catch (_: Throwable){false}
    }

}
