package com.tapresearch.tapsdk.utils

import android.app.Activity
import android.app.ActivityManager
import android.content.Context
import android.content.Context.ACTIVITY_SERVICE
import android.os.Build
import android.view.WindowManager

internal object ActivityUtils {
    internal fun allowShowFromLockscreen(logTag: String, activity: Activity) {
        try {
            if (Build.VERSION.SDK_INT >= 27) {
                activity.setShowWhenLocked(true)
                activity.setTurnScreenOn(true)
            } else {
                val win = activity.window
                win.addFlags(WindowManager.LayoutParams.FLAG_SHOW_WHEN_LOCKED)
                win.addFlags(
                        WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON
                                or WindowManager.LayoutParams.FLAG_TURN_SCREEN_ON
                                or WindowManager.LayoutParams.FLAG_ALLOW_LOCK_WHILE_SCREEN_ON,
                )
            }
        }catch (t: Throwable) {
            LogUtils.e(logTag,"allowShowFromLockscreen failed",t)
        }
    }

    internal fun memorySnapshot(context: Context?): String {

        try {
            if (context == null)
                return ""

            // Declaring and Initializing the ActivityManager
            val actManager = context.getSystemService(ACTIVITY_SERVICE) as ActivityManager

            // Declaring MemoryInfo object
            val memInfo = ActivityManager.MemoryInfo()

            // Fetching the data from the ActivityManager
            actManager.getMemoryInfo(memInfo)

            // Fetching the available and total memory and converting into Giga Bytes
            val availMemory = memInfo.availMem.toDouble() / (1024 * 1024 * 1024)
            val totalMemory = memInfo.totalMem.toDouble() / (1024 * 1024 * 1024)

            // Displaying the memory info into the TextView
            return "[Avail. Mem: $availMemory\nTotal: $totalMemory]"
        } catch (throwable: Throwable) {
            LogUtils.internal("ActivityUtils", "could not determine memory snapshot: $throwable")
            return ""
        }
    }

    internal fun usedMemory(context: Context?): Array<String>? {
        try {
            if (context == null)
                return null

            // Declaring and Initializing the ActivityManager
            val actManager = context.getSystemService(ACTIVITY_SERVICE) as ActivityManager

            // Declaring MemoryInfo object
            val memInfo = ActivityManager.MemoryInfo()

            // Fetching the data from the ActivityManager
            actManager.getMemoryInfo(memInfo)

            // Fetching the available and total memory and converting into MB
            val availMemory = memInfo.availMem.toDouble() / (1024 * 1024)
            val totalMemory = memInfo.totalMem.toDouble() / (1024 * 1024)

            return arrayOf(totalMemory.toString(), (totalMemory-availMemory).toString())
        } catch (throwable: Throwable) {
            LogUtils.internal("ActivityUtils", "could not determine available memory: $throwable")
            return null
        }
    }

}
