package com.tapresearch.tapsdk.storage

import android.content.Context

internal object PreferenceManager {

    private const val USE_HOTH_KEY = "tap-rewards-load-hoth-environment"

    fun getUseHothLegacyPrefs(context: Context): Boolean {
        try {
            val sharedPref = context.getSharedPreferences(USE_HOTH_KEY, Context.MODE_PRIVATE)
            return sharedPref.getBoolean(USE_HOTH_KEY, false)
        } catch (throwable: Throwable) {
            return false
        }
    }

    // for testing/verification
    fun saveUseHothLegacyPrefs(context: Context, useHoth: Boolean) {
        val sharedPref = context.getSharedPreferences(USE_HOTH_KEY, Context.MODE_PRIVATE)
        sharedPref.edit().putBoolean(USE_HOTH_KEY, useHoth).apply()
    }
}
