package com.tapresearch.tapsdk.receiver

import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import com.tapresearch.tapsdk.TapResearch
import com.tapresearch.tapsdk.state.SdkState
import com.tapresearch.tapsdk.utils.ConnectionUtils
import com.tapresearch.tapsdk.utils.LogUtils
import com.tapresearch.tapsdk.utils.RemoteEventLogger
import com.tapresearch.tapsdk.utils.TapConstants
import com.tapresearch.tapsdk.utils.TapConstants.REMOTE_LOG_LEVEL
import kotlinx.serialization.InternalSerializationApi

@InternalSerializationApi
internal class ScreenONReceiver : BroadcastReceiver() {

    companion object {
        private const val TAG = "ScreenStateReceiver"
        private const val DO_NOT_USE = true
        internal fun register(context: Context) {
            if (DO_NOT_USE) {
                // see https://tapresearchinc.atlassian.net/browse/PUB-1314
                return
            }
            try {
                val screenStateFilter = IntentFilter()
                screenStateFilter.addAction(Intent.ACTION_SCREEN_ON)
                context.applicationContext.registerReceiver(
                    ScreenONReceiver(),
                    screenStateFilter,
                )
            } catch (t: Throwable) {
                LogUtils.internal(
                    TAG,
                    "failed to register receiver: $t",
                )
            }
        }
    }

    override fun onReceive(context: Context?, intent: Intent?) {/*
        onReceive is always on the main thread
        LogUtils.internal(
            TAG,
            "screen awake: ${intent?.action} myLooper is mainLooper? ${Looper.myLooper() == Looper.getMainLooper()}",
        )
        */
        context?.let {
            if (ConnectionUtils.isOnline(it)) {
                TapResearch.orchestrator?.apply {
                    checkOrca { isOk, reason ->
                        if (!isOk) {
                            if (sdkStateHolder.state != SdkState.initializing) {
                                LogUtils.internal(TAG, "screen awake. orca not ok. restart.")
                                RemoteEventLogger.postEvent(
                                    REMOTE_LOG_LEVEL,
                                    "ScreenONReceiver.onReceive",
                                    "$reason. sdk status at time of death: ${sdkStateHolder.state}",
                                    null,
                                    TapConstants.LOG_CAT_ORCA_REVIVE,
                                    TapConstants.LOG_DET_ORCA_REVIVE_ATTEMPT
                                )
                                restart()
                            }
                        } else {
                            LogUtils.internal(TAG, "screen awake. orca ok.")
                        }
                    }
                }
            }
        }
    }
}
