package com.tapresearch.tapsdk.callback

import com.tapresearch.tapsdk.models.QQPayload

/**
 * TapResearch Quick Question callback.  Indicates when a Quick Question has been answered
 * and completed and the question dialog has been dismissed.
 *
 * @see com.tapresearch.tapsdk.TapResearch.setQuickQuestionCallback
 * @see com.tapresearch.tapsdk.TapResearch.initialize
 *
 */
fun interface TRQQDataCallback {

    /**
     * Invoked whenever a Quick Question has been completed and the dialog dismissed.
     *
     * @param data - Contains all the data pertaining to a Quick Question that has been answered.
     */
    fun onQuickQuestionDataReceived(data: QQPayload)
}


