package com.tapresearch.tapsdk.utils

import com.tapresearch.tapsdk.utils.TapConstants.REMOTE_LOG_LEVEL
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.Job
import kotlinx.coroutines.delay
import kotlinx.coroutines.launch

internal object TimerUtil {

    private const val TAG = "TimerUtil"
    private val timers = HashMap<String, Job>()
    fun startTimer(label: String, durationSeconds: Int, timeoutAction: () -> Unit) {
        synchronized(this@TimerUtil) {
            timers[label]?.cancel()
            var secondsElapsed = 0
            timers[label] = CoroutineScope(Dispatchers.IO).launch {
                try {
                    LogUtils.internal(TAG, "starting $label ..")
                    for (i in 1..durationSeconds) {
                        delay(1000L)
                        secondsElapsed++
                    }
                    timeoutAction()
                } catch (ignored: Throwable) {}
            }
        }
    }

    fun stopTimer(label: String) {
        synchronized(this@TimerUtil) {
            timers[label]?.cancel()
        }
    }
}
