package com.tapresearch.tapsdk.utils

import android.os.StatFs


internal object StorageUtil {

    private var stat: StatFs? = null

    init {
        try {
            stat = StatFs(android.os.Environment.getExternalStorageDirectory().path)
        }catch (ignored: Throwable){}
    }

    fun freeDiskSpace(): String? {
        val i = getInternalFreeSpace()
        return if (i > 0) {
            bytesToMB(i)
        } else {
            null
        }
    }

    fun totalDiskSpace(): String? {
        val i = getInternalTotalSpace()
        return if (i > 0) {
            bytesToMB(i)
        } else {
            null
        }
    }

    private fun getInternalFreeSpace(): Long {
        stat?.let {
            return it.blockSizeLong * it.availableBlocksLong
        }
        return 0
    }

    private fun getInternalTotalSpace(): Long {
        stat?.let {
            return it.blockSizeLong * it.blockCountLong
        }
        return 0
    }

    private fun getInternalUsedSpace(): Long {
        return getInternalTotalSpace() - getInternalFreeSpace()
    }

    private fun bytesToMB(bytes: Long): String {
        val mbs = (bytes / (1024 * 1024)).toFloat()
        return mbs.toString()
    }
}
