package com.tapresearch.tapsdk.utils

import com.tapresearch.tapresearchkotlinsdk.BuildConfig

internal object PlatformUtils {

    private const val TAG = "TRLog_Vers"

    internal fun devPlatform():String {
        if (isUnity()) {
            return "unity"
        } else if (isReact()) {
            return "react"
        } else {
            return "android"
        }
    }

    internal fun devVersion():String {
        if (isUnity()) {
            return unityBridgeVersion()
        } else if (isReact()) {
            return reactBridgeVersion()
        } else {
            return BuildConfig.TAP_SDK_VERSION
        }
    }

    internal fun isUnity(): Boolean {
        return try {
            Class.forName("com.unity3d.player.UnityPlayer")
            true
        } catch (e: ClassNotFoundException) {
            false
        }
    }

    internal fun unityBridgeVersion():String {
        try {
            val classObject = Class.forName("com.tapresearch.ktunitybridge.BuildConfig")
            val field = classObject.getField("TAP_UNITY_BRIDGE_VERSION")
            field.isAccessible = true
            field.get(null)?.let {
                return it as String
            }
        }catch (e: Exception) {
            LogUtils.e(TAG, "unityBridgeVersion(): $e")
        }
        return BuildConfig.TAP_SDK_VERSION
    }

    internal fun isReact(): Boolean {

        try {
            Class.forName("com.tapresearch.tapsdk.ReactNativeBridgeVersion")
            return true
        }catch (e: ClassNotFoundException) {
            //try next below, could be an older react native bridge that doesn't have version class
        }
        return try {
            Class.forName("com.tapresearch.tapsdk.TapsdkPackage")
            return true
        } catch (e: ClassNotFoundException) {
            false
        }
    }

    internal fun reactBridgeVersion(): String {
        try {
            val classObject = Class.forName("com.tapresearch.tapsdk.ReactNativeBridgeVersion")
            val field = classObject.getField("VERSION")
            field.isAccessible = true
            field.get(null)?.let {
                return it as String
            }
        }catch (e: Exception) {
            LogUtils.e(TAG, "reactBridgeVersion(): $e")
        }
        return BuildConfig.TAP_SDK_VERSION
    }

}
