package com.tapresearch.tapsdk.storage

import com.tapresearch.tapsdk.models.configuration.TRSdkFeatureToggle
import com.tapresearch.tapsdk.utils.LogUtils
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

internal object SdkToggles {
    const val RETRY_CALLBACK_ON_RESTART = "retry_last_callback_on_restart"
}
internal object SdkFeatureToggleStorage {
    private val toggles: MutableSet<TRSdkFeatureToggle> = mutableSetOf(
        TRSdkFeatureToggle(
            name = SdkToggles.RETRY_CALLBACK_ON_RESTART,
            isEnabled = true,
        )
    )
    private val json = Json { ignoreUnknownKeys = true }
    private const val LOG_TAG = "SdkFeatureToggles"

    fun decode(toggleJson: String): List<TRSdkFeatureToggle> {
        return json.decodeFromString(toggleJson)
    }

    fun update(toggle: TRSdkFeatureToggle) {
        LogUtils.internal(LOG_TAG, "Updating toggle: $toggle")

        toggles.find { t -> t.name == toggle.name }?.let {
            it.isEnabled = toggle.isEnabled
        } ?: toggles.add(toggle)
    }

    fun isEnabled(name: String): Boolean {
        return toggles.find { t -> t.name == name }?.isEnabled ?: false
    }
}
