package com.tapresearch.tapsdk.storage

import com.tapresearch.tapsdk.models.TRError
import com.tapresearch.tapsdk.models.TRPlacement
import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

@InternalSerializationApi
internal object PlacementStorage {
    private val placements: MutableSet<TRPlacement> = mutableSetOf()
    private val json = Json { ignoreUnknownKeys = true }

    fun decode(placementJson: String): TRPlacement {
        return json.decodeFromString(placementJson)
    }

    fun add(placement: TRPlacement) {
        placements.removeAll { p -> p.tag == placement.tag }
        placements.add(placement)
    }

    fun remove(placement: TRPlacement) {
        placements.removeAll { p -> p.tag == placement.tag }
    }

    fun getPlacementByTag(tag: String): TRPlacement {
        return placements.find { p -> p.tag == tag } ?: errorPlacement(tag)
    }

    fun getPlacementByTagOrNull(tag: String): TRPlacement? {
        return placements.find { p -> p.tag == tag }
    }

    private fun errorPlacement(tag: String): TRPlacement {
        val error = TRError(code = 2000, description = "Invalid placement tag: $tag")
        return TRPlacement(tag = "error-placement", error = error)
    }
}
