package com.tapresearch.tapsdk.callback

import android.webkit.JavascriptInterface
import com.tapresearch.tapsdk.TapResearch
import kotlinx.serialization.InternalSerializationApi
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlinx.serialization.decodeFromString
import kotlinx.serialization.json.Json

@InternalSerializationApi @Serializable
internal data class TROfferNavigationPayload(
    @SerialName("offer_url")
    val offerUrl: String? = null,
)

@InternalSerializationApi
internal class TRSurveyInterface(
    private val offerNavigationCallback: ((url: String) -> Unit)
) {

    @JavascriptInterface
    fun onSurveyWallMessage(surveyMessagePayload: String?) {
        // LogUtils.d("TRSurveyInterface", "onSurveyWallMessage: $surveyMessagePayload")

        surveyMessagePayload?.let {
            TapResearch.orchestrator?.evaluateJavascript("sdkMessageReceived('$surveyMessagePayload')")
        }
    }

    @OptIn(InternalSerializationApi::class)
    @JavascriptInterface
    fun onHandleOfferNavigation(offerNavigationPayload: String?) {
        // LogUtils.d("TRSurveyInterface", "onHandleOfferNavigation: $offerNavigationPayload")
        val json = Json { ignoreUnknownKeys = true }

        offerNavigationPayload?.let {
            val navJson: TROfferNavigationPayload? = json.decodeFromString(offerNavigationPayload)
            navJson?.offerUrl?.let { offerNavigationCallback(it) }
        }
    }

}
