package com.tapresearch.tapsdk.models

import com.tapresearch.tapsdk.models.configuration.TRConfiguration
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class TROfferEvent(
    @SerialName("id")
    val id: Int? = null,

    @SerialName("event_type")
    val eventType: String? = null,

    @SerialName("start_time")
    val startTime: String? = null,

    @SerialName("end_time")
    val endTime: String? = null,

    @SerialName("tag")
    val tag: String? = null,

    @SerialName("identifier")
    val identifier: String? = null,

    @SerialName("placement_type")
    val placementType: String? = null,

    @SerialName("offer_event_configuration")
    val offerEventConfiguration: OfferEventConfiguration? = null,
)

@Serializable
internal data class OfferEventConfiguration(
    val portrait: TRConfiguration? = null,
    val landscape: TRConfiguration? = null,
)
