package com.tapresearch.tapsdk.models.configuration

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class TRConfigurationNavBar(
    val show: Int? = null,
    @SerialName("background_color")
    val backgroundColor: String? = null,
    val title: String? = null,
    @SerialName("close_nav_item")
    val closeNavItem: CloseNavItem? = null,
    @SerialName("abandon_nav_item")
    val abandonNavItem: AbandonNavItem? = null,
    @SerialName("refresh_nav_item")
    val refreshNavItem: RefreshNavItem? = null,
)

@Serializable
internal data class AbandonNavItem(
    val title: String? = null,
    @SerialName("abandon_modal")
    val abandonModal: AbandonModal? = null,
)

@Serializable
internal data class AbandonModal(
    val title: String? = null,
    val message: String? = null,
    @SerialName("action_title")
    val actionTitle: String? = null,
    @SerialName("dismiss_title")
    val dismissTitle: String? = null,
    @SerialName("action_destructive")
    val actionDestructive: Int? = null,
)

@Serializable
internal data class CloseNavItem(
    val title: String? = null,
)

@Serializable
internal data class RefreshNavItem(val image: String? = null)
