package com.tapresearch.tapsdk.webview

import android.annotation.SuppressLint
import android.app.Activity
import android.os.Bundle
import android.webkit.WebResourceRequest
import android.webkit.WebView
import android.webkit.WebViewClient
import android.widget.LinearLayout
import android.widget.Toolbar
import androidx.core.content.ContextCompat
import com.tapresearch.tapresearchkotlinsdk.R

/**
 * Simple WebView to show privacy policy, cookie policy, terms, etc..
 * Use in lieu of Intent.ACTION_VIEW because more performant.
 */
internal class TRSimpleWebView : Activity() {

    @SuppressLint("SetJavaScriptEnabled")
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        val toolbar = Toolbar(this)
        setupToolbar(toolbar)
        val webView = WebView(this)
        webView.apply {
            settings.javaScriptEnabled = true
            settings.domStorageEnabled = true
            webViewClient = object : WebViewClient() {
                override fun shouldOverrideUrlLoading(view: WebView, request: WebResourceRequest): Boolean {
                    return true
                }
            }
        }
        webView.loadUrl(intent.data.toString())
        val layout = LinearLayout(this).apply {
            orientation = LinearLayout.VERTICAL // Setting the orientation to vertical
            layoutParams = LinearLayout.LayoutParams(
                    LinearLayout.LayoutParams.MATCH_PARENT,
                    LinearLayout.LayoutParams.MATCH_PARENT,
            )
            addView(toolbar)
            addView(webView)
        }
        setContentView(layout)
    }

    private fun setupToolbar(toolbar: Toolbar) {
        toolbar.apply {
            title = ""
            //background = ColorDrawable(Color.parseColor(navigationBar.backgroundColor))
            navigationIcon = ContextCompat.getDrawable(
                    this@TRSimpleWebView,
                    R.drawable.baseline_arrow_back_black_18,
            )
            setNavigationOnClickListener {
                finish()
            }
        }
    }

}
