package com.tapresearch.tapsdk.webview

import android.content.Context
import android.content.res.Configuration
import android.content.res.Resources
import com.tapresearch.tapsdk.models.configuration.Frame
import com.tapresearch.tapsdk.utils.DeviceUtils.isFlat
import com.tapresearch.tapsdk.utils.DeviceUtils.isFoldableDevice

internal object TRDialogUtils {

    /**
     * Adjustment only needed if the device is a foldable device.
     *
     * @param frame
     */
    internal fun adjustFramePosition(context: Context, frame: Frame, origPortraitY: Float?, origLandscapeY: Float?) {

        if (isFoldableDevice(context)) {
            frame.x = (((Resources.getSystem().displayMetrics.widthPixels/Resources.getSystem().displayMetrics.density).toInt()) - (frame.width?:0f)) / 2

            if (isFlat()) {
                frame.y = origPortraitY
            } else {
                frame.y = if (Resources.getSystem().configuration.orientation == Configuration.ORIENTATION_PORTRAIT) origPortraitY else origLandscapeY
            }

            if (isBanner(frame)) { //handle special case
                frame.y = (Resources.getSystem().displayMetrics.heightPixels*.9f) / Resources.getSystem().displayMetrics.density
            }
        }
    }

    private fun isBanner(frame: Frame):Boolean {
        if (frame.x == null || frame.y == null || frame.width == null || frame.height == null) return false

        val screenHeight = Resources.getSystem().displayMetrics.heightPixels / Resources.getSystem().displayMetrics.density

        // consider banner if frame height less than 100 and frame y is lower than the bottom half
        return frame.height < 100f && frame.y!! > (screenHeight / 2)
    }
}
