package com.tapresearch.tapsdk.utils

import android.util.Log
import com.tapresearch.tapresearchkotlinsdk.BuildConfig
import com.tapresearch.tapsdk.state.LogLevel

internal class LogUtils {
    companion object {
        var currentLogLevel: LogLevel = if (BuildConfig.DEBUG) LogLevel.DEBUG else LogLevel.ERROR
        fun d(tag: String, message: String): Int {
            return if (currentLogLevel == LogLevel.DEBUG) {
                Log.d("[TR] $tag", message)
            } else {
                -1
            }
        }

        fun e(tag: String, message: String, error: Throwable? = null): Int {
            return if (currentLogLevel == LogLevel.DEBUG) {
                Log.e("[TR] $tag", message, error)
            } else {
                -1
            }
        }

        fun i(tag: String, message: String, error: Throwable? = null): Int {
            return if (currentLogLevel == LogLevel.DEBUG) {
                Log.i("[TR] $tag", message, error)
            } else {
                -1
            }
        }

        fun internal(tag: String, message: String): Int {
            return if (BuildConfig.DEBUG) {
                Log.w("[TR_Internal] $tag", message)
            } else {
                -1
            }
        }

    }
}
