package com.tapresearch.tapsdk.utils

import android.content.Context
import java.util.concurrent.TimeUnit

/**
 * Do not explicitly require publishers to include the following dependency
 * so use fully qualified class names to avoid build issues
 *
 * implementation 'com.google.android.gms:play-services-appset:16.1.0'
 */
internal object AppIdUtil {

    internal fun getAppId(context: Context): String? {
        return try {
            val client = com.google.android.gms.appset.AppSet.getClient(context)
            val task: com.google.android.gms.tasks.Task<com.google.android.gms.appset.AppSetIdInfo> =
                client.appSetIdInfo
            com.google.android.gms.tasks.Tasks.await(task, 250, TimeUnit.MILLISECONDS)
            task.result?.id
        }catch (_: Throwable) {
            null
        }
    }
}
