package com.tapresearch.tapsdk.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

/**
 * TapResearch Survey - Use for the TapResearch survey preview feature.
 *
 * @property surveyId Unique survey id.  Use when calling com.tapresearch.tapsdk.TapResearch.showSurveyForPlacement
 * @property lengthInMinutes Length of the survey in minutes.
 * @property rewardAmount Reward amount
 * @property currencyName Currency name
 * @property isSale Is this survey a sale?
 * @property saleEndDate Sale end date
 * @property saleMultiplier Sale multiplier. E.g. Earn 2.5x the normal, pre-sale reward amount.
 * @property preSaleRewardAmount The pre-sale reward amount, if this is a sale.
 * @property isHotTile Is this a 'Hot' tile?
 *
 * @see com.tapresearch.tapsdk.TapResearch.showSurveyForPlacement
 */
@Serializable
data class TRSurvey(
    @SerialName("survey_identifier")
    val surveyId: String? = null,
    @SerialName("length_in_minutes")
    val lengthInMinutes: Int? = null,
    @SerialName("reward_amount")
    val rewardAmount: Float? = null,
    @SerialName("currency_name")
    val currencyName: String? = null,
    @SerialName("is_sale")
    var isSale: Boolean? = null,
    @SerialName("sale_end_date")
    var saleEndDate: String? = null,
    @SerialName("sale_multiplier")
    var saleMultiplier: Float? = null,
    @SerialName("pre_sale_reward_amount")
    var preSaleRewardAmount: Float? = null,
    @SerialName("is_hot_tile")
    var isHotTile: Boolean? = null,
)

@Serializable
internal data class TRSurveyRefreshPayload(
    @SerialName("placement_tag")
    val placementTag: String? = null,
)
