package com.tapresearch.tapsdk.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class QuickQuestionsDataPayload(
    @SerialName("survey_identifier") val surveyIdentifier: String,
    @SerialName("app_name") val appName: String,
    @SerialName("api_token") val apiToken: String,
    @SerialName("sdk_version") val sdkVersion: String,
    @SerialName("platform") val platform: String,
    @SerialName("placement_tag") val placementTag: String,
    @SerialName("user_identifier") val userIdentifier: String,
    @SerialName("user_locale") val userLocale: String,
    @SerialName("seen_at") val seenAt: String,
    @SerialName("complete") val complete: Complete?,
    @SerialName("questions") val questions: List<QuickQuestionsDataPayloadQuestion>,
    @SerialName("target_audience") val targetAudience: List<QuickQuestionsDataPayloadTargetFilter>?,
)

/**
 * Complete - contains information regarding when a quick question was completed.
 *
 * @property completeIdentifier
 * @property completedAt
 */
@Serializable
data class Complete(
    @SerialName("complete_identifier") val completeIdentifier: String,
    @SerialName("completed_at") val completedAt: String,
)

@Serializable
internal data class QuickQuestionsDataPayloadQuestion(
    @SerialName("question_identifier") val questionIdentifier: String,
    @SerialName("question_text") val questionText: String,
    @SerialName("question_type") val questionType: String,
    @SerialName("rating_scale_size") val ratingScaleSize: Int?,
    @SerialName("user_answer") val userAnswer: UserAnswer?,
)

/**
 * User answer to a quick question.
 *
 * @property value
 * @property identifiers
 */
@Serializable
data class UserAnswer(
    @SerialName("value") val value: String,
    @SerialName("identifiers") val identifiers: List<String>,
)

@Serializable
internal data class QuickQuestionsDataPayloadTargetFilter(
    @SerialName("filter_attribute_name") val filterAttributeName: String,
    @SerialName("filter_operator") val filterOperator: String,
    @SerialName("filter_value") val filterValue: String,
    @SerialName("user_value") val userValue: String,
)

