package com.tapresearch.tapsdk.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
internal data class QuickQuestion(
    @SerialName("type")
    val type: String,
    @SerialName("payload")
    val payload: QQPayload,
)

/**
 * Quick Question payload.  Comes back in the TRQQDataCallback event.
 *
 *
 * @property surveyIdentifier Unique survey identifier.
 * @property appName App name
 * @property apiToken API Token
 * @property sdkVersion SDK Version
 * @property platform Platform
 * @property placementTag The placement tag string.  E.g. "home-screen" or "earn-center".
 * @property userIdentifier Unique user identifier
 * @property userLocale User locale
 * @property seenAt Seen-at
 * @property complete Complete
 * @property questions List of Questions
 * @property targetAudience Target Audience
 *
 * @see com.tapresearch.tapsdk.callback.TRQQDataCallback
 */
@Serializable
data class QQPayload(
    @SerialName("survey_identifier")
    val surveyIdentifier: String,
    @SerialName("app_name")
    val appName: String,
    @SerialName("api_token")
    val apiToken: String,
    @SerialName("sdk_version")
    val sdkVersion: String,
    @SerialName("platform")
    val platform: String,
    @SerialName("placement_tag")
    val placementTag: String,
    @SerialName("user_identifier")
    val userIdentifier: String,
    @SerialName("user_locale")
    val userLocale: String,
    @SerialName("seen_at")
    val seenAt: String,
    @SerialName("complete")
    val complete: Complete?,
    @SerialName("questions")
    val questions: List<Question>,
    @SerialName("target_audience")
    val targetAudience: Array<Map<String, String>>?,
)

@Serializable
internal data class QQComplete(
    @SerialName("complete_identifier")
    val completeIdentifier: String,
    @SerialName("completed_at")
    val completedAt: String,
)

@Serializable
data class Question(
    @SerialName("question_identifier")
    val questionIdentifier: String,
    @SerialName("question_text")
    val questionText: String,
    @SerialName("question_type")
    val questionType: String,
    @SerialName("user_answer")
    val userAnswer: UserAnswer?,
)

@Serializable
internal data class QQUserAnswer(
    @SerialName("value")
    val value: String,
    @SerialName("identifiers")
    val identifiers: List<String>,
)
